%% 3D SMOOTH BOUNDARY REPRESENTATION
function display_3Dsmooth(xg,top, iter)
[nely,nelx,nelz] = size(xg);
cla, hold on, view(30,30), rotate3d on, axis equal, axis([0 nelx 0 nelz 0 nely]), box
set(gca,'YDir','reverse','ZDir','reverse','ZtickLabel',flipud(get(gca,'Ztick')'));
% set(gcf,'MenuBar','none','ToolBar','none')
[X,Y,Z] = meshgrid(1:nelx,1:nely,1:nelz);
fcolor=[0 1 1];%fcolor= [1,0.98,0.94]; %Object color
patch(isocaps(X,Z,Y,top,0),'FaceColor',fcolor,'EdgeColor','none');
p = patch(isosurface(X,Z,Y,top,0),'FaceColor',fcolor,'EdgeColor','none');
camlight('headlight')
axis off;
box off;
set(gcf, 'color', [1 1 1]) %Background
drawnow
%    print(gcf,['STopology\iter-',num2str(iter),'.tiff'],'-dtiff','-r500');
%    saveas(gcf,['STopology\iter-',num2str(iter),'.png']);
end